// ==========================================================================
//code=EUC	tab=4
//
// wizd:	MediaWiz Server daemon.
//
// 		wizd_listen.c
//											$Revision: 1.6 $
//											$Date: 2004/03/06 13:52:56 $
//
//	٤ƼǤǤʤޤġ
//  ΥեȤˤĤVertexLink䤤碌ʤǤ
// ==========================================================================

#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <netinet/in.h>
#include <signal.h>
#include <arpa/inet.h>

#include "wizd.h"

int volatile child_count = 0;
#define MAX_CHILD_COUNT (global_param.max_child_count)

// **********************************************************************
// HTTP Ԥư
// **********************************************************************
void	server_listen()
{
	int    ret;
	int    pid;

	int		listen_socket;	// ԤSocket
	int		accept_socket;	// ³Socket

	struct sockaddr_in    saddr;		// Хåȥɥ쥹¤
	struct sockaddr_in    caddr;		// 饤ȥåȥɥ쥹¤
	int    caddr_len = sizeof(caddr);	// 饤ȥåȥɥ쥹¤ΤΥ

	int		sock_opt_val;


	int		access_check_ok;
	int			i;
	unsigned char	client_addr_str[32];
	unsigned char	client_address[4];
	unsigned char	masked_client_address[4];
	unsigned char	work1[32];
	unsigned char	work2[32];

	// =============================
	// listenå
	// =============================
	listen_socket = socket(AF_INET, SOCK_STREAM, 0);
	if ( listen_socket < 0 ) // åԥå
	{
		debug_log_output("socket() error.");
		perror("socket");
		exit( 1 );
	}

	// ===============================
	// SO_REUSEADDR򥽥åȤ˥å
	// ===============================
	sock_opt_val = 1;
	setsockopt(listen_socket, SOL_SOCKET, SO_REUSEADDR, (char *)&sock_opt_val, sizeof(sock_opt_val));

	// ===========================================
	// åȥɥ쥹¤Τͤ򥻥å
	// ===========================================
	memset( (char *)&saddr, 0, sizeof(saddr) );
	saddr.sin_family = AF_INET;
	saddr.sin_addr.s_addr = htonl(INADDR_ANY);
	saddr.sin_port = htons(global_param.server_port);

	// =============================
	// bind ¹
	// =============================
	ret = bind(listen_socket, (struct sockaddr *)&saddr, sizeof(saddr));
	if ( ret < 0 ) // bind ԥå
	{
		debug_log_output("bind() error. ret=%d\n", ret);
		perror("bind");
		return;
	}

	// =============================
	// listen¹
	// =============================
	ret = listen(listen_socket, LISTEN_BACKLOG);
	if ( ret < 0 )  // listenԥå
	{
		debug_log_output("listen() error. ret=%d\n", ret);
		perror("listen");
		return;
	}

	// =====================
	// ᥤ롼
	// =====================
	while ( 1 )
	{
		// ====================
		// AcceptԤ.
		// ====================
		if (MAX_CHILD_COUNT > 0 && child_count >= MAX_CHILD_COUNT) {
			debug_log_output("Waiting for a child_count is going down... "
				"%d / %d\n", child_count, MAX_CHILD_COUNT);
			while (MAX_CHILD_COUNT > 0 && child_count >= MAX_CHILD_COUNT) {
				sleep(1);
			}
		}
		debug_log_output("Waiting for a new client...");
		accept_socket = accept(listen_socket, (struct sockaddr *)&caddr, &caddr_len);
		if ( accept_socket < 0 ) // acceptԥå
		{
			debug_log_output("accept() error. ret=%d\n", accept_socket);
			continue;		// ǽ롣
		}
		debug_log_output("\n\n=============================================================\n");
		debug_log_output("Socket Accept!!(accept_socket=%d)\n", accept_socket);

		child_count ++;
		rand();

		// ========================
		// fork¹
		// ========================
		pid = fork();
		if ( pid < 0 ) // forkԥå
		{
			printf("fork() error. ret=%d\n", pid);
			close(accept_socket);	// ǰåȤĤ롣
			continue;				// ǽ롣
		}

		if (pid == 0)
		{
			// ʲҥץ
			debug_log_output("fork success!!(pid=%d)\n", pid);

			// listen_socketĤ롣
			close(listen_socket);


			// caddr ɽ
			debug_log_output("client addr = %s\n", inet_ntoa(caddr.sin_addr) );
			debug_log_output("client port = %d\n", ntohs(caddr.sin_port) );


			// ==============================
			// å
			// ==============================
			access_check_ok = FALSE;

			// -------------------------------------------------------------------------
			// Access Allowå
			//  ꥹȤ饤ȥɥ쥹ꥹȤ˰פϣˤȤ롣
			// -------------------------------------------------------------------------
			if ( access_allow_list[0].flag == FALSE ) // ꥹȤ
			{
				// åϣˤȤ롣
				debug_log_output("No Access Allow List. No Check.\n");
				access_check_ok = TRUE;
			}
			else
			{
				debug_log_output("Access Check.\n");


				// 饤ȥɥ쥹
				strncpy(client_addr_str, inet_ntoa(caddr.sin_addr), sizeof(client_addr_str));

				// client_addr_strchar[4]Ѵ
				strncat(client_addr_str, ".", sizeof(client_addr_str) - strlen(client_addr_str));
				for (i=0; i<4; i++ )
				{
					sentence_split(client_addr_str, '.', work1, work2);
					client_address[i] = (unsigned char)atoi(work1);
					strncpy(client_addr_str, work2, sizeof(client_addr_str));
				}

				// ꥹȤ¸ߤ롼
				for ( i=0; i<ACCESS_ALLOW_LIST_MAX; i++ )
				{
					if ( access_allow_list[i].flag == FALSE ) // ꥹȽλ
						break;

					// masked_client_address 
					masked_client_address[0] = client_address[0] & access_allow_list[i].netmask[0];
					masked_client_address[1] = client_address[1] & access_allow_list[i].netmask[1];
					masked_client_address[2] = client_address[2] & access_allow_list[i].netmask[2];
					masked_client_address[3] = client_address[3] & access_allow_list[i].netmask[3];

					// Ӽ¹
					if ( 	(masked_client_address[0] == access_allow_list[i].address[0]) &&
							(masked_client_address[1] == access_allow_list[i].address[1]) &&
							(masked_client_address[2] == access_allow_list[i].address[2]) &&
							(masked_client_address[3] == access_allow_list[i].address[3]) 	)
					{
						debug_log_output("[%d.%d.%d.%d] == [%d.%d.%d.%d] accord!!",
										masked_client_address[0], masked_client_address[1], masked_client_address[2], masked_client_address[3],
										access_allow_list[i].address[0],access_allow_list[i].address[1],access_allow_list[i].address[2], access_allow_list[i].address[3] );

						access_check_ok = TRUE;
						break;
					}
					else
					{
						debug_log_output("[%d.%d.%d.%d] == [%d.%d.%d.%d] discord!!",
										masked_client_address[0], masked_client_address[1], masked_client_address[2], masked_client_address[3],
										access_allow_list[i].address[0],access_allow_list[i].address[1],access_allow_list[i].address[2], access_allow_list[i].address[3] );
					}
				}
			}


			if ( access_check_ok == FALSE )
			{
				debug_log_output("Access Denied.\n");

				close(accept_socket);	// Socket
				exit( 0 ); // ҥץλ

			}


			// HTTPȤơŻ¹
			server_http_process(accept_socket);

			debug_log_output("HTTP process end.\n");
			debug_log_output("=============================================================\n");

			close(accept_socket);	// Socket
			exit( 0 ); // ҥץｪλ
		}

		// ƥץaccept_socketĤ
		close(accept_socket);
	}


	return;
}

