unsigned char *base64(unsigned char *instr)
{
	static unsigned char out[256];
	unsigned char *p = out;
	int count = 0;
	char tbl[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";


/*
	ABC -> 414243 -> 0100 0001  0100 0010  0100 0011
				->   010000 010100 001001 000011
					 10 14 09 03
*/


	while (*instr) {
		switch (count) {
		case 0:
			*p   = (*instr >> 2)&0x3f;
			break;
		case 1:
			*p   = (*instr++ << 4)&0x3f;
			*p  |= (*instr >> 4)&0x3f;
			break;
		case 2:
			*p   = (*instr++ << 2)&0x3f;
			*p  |= (*instr >> 6)&0x3f;
			break;
		case 3:
			*p   = (*instr++)&0x3f;
			break;
		}
		count++;
		count %= 4;
		*p = tbl[*p];
		*++p = '\0';
	}
	count = (4-count)%4;
	while (count-- > 0) {
		*p++ = '=';
		*p = '\0';
	}
	return out;
}
